/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulator;
import net.minecraft.world.level.storage.loot.ContainerComponentManipulators;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetContainerContents
extends LootItemConditionalFunction {
    public static final MapCodec<SetContainerContents> CODEC = RecordCodecBuilder.mapCodec(p_340801_ -> SetContainerContents.commonFields(p_340801_).and(p_340801_.group((App)ContainerComponentManipulators.CODEC.fieldOf("component").forGetter(p_340802_ -> p_340802_.component), (App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(p_298103_ -> p_298103_.entries))).apply((Applicative)p_340801_, SetContainerContents::new));
    private final ContainerComponentManipulator<?> component;
    private final List<LootPoolEntryContainer> entries;

    SetContainerContents(List<LootItemCondition> p_193035_, ContainerComponentManipulator<?> p_340836_, List<LootPoolEntryContainer> p_298300_) {
        super(p_193035_);
        this.component = p_340836_;
        this.entries = List.copyOf(p_298300_);
    }

    public LootItemFunctionType<SetContainerContents> getType() {
        return LootItemFunctions.SET_CONTENTS;
    }

    @Override
    public ItemStack run(ItemStack p_80911_, LootContext p_80912_) {
        if (p_80911_.isEmpty()) {
            return p_80911_;
        }
        Stream.Builder $$2 = Stream.builder();
        this.entries.forEach(p_80916_ -> p_80916_.expand(p_80912_, p_287573_ -> p_287573_.createItemStack(LootTable.createStackSplitter(p_80912_.getLevel(), $$2::add), p_80912_)));
        this.component.setContents(p_80911_, $$2.build());
        return p_80911_;
    }

    @Override
    public void validate(ValidationContext p_80918_) {
        super.validate(p_80918_);
        for (int $$1 = 0; $$1 < this.entries.size(); ++$$1) {
            this.entries.get($$1).validate(p_80918_.forChild(".entry[" + $$1 + "]"));
        }
    }

    public static Builder setContents(ContainerComponentManipulator<?> p_341284_) {
        return new Builder(p_341284_);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ContainerComponentManipulator<?> component;

        public Builder(ContainerComponentManipulator<?> p_341204_) {
            this.component = p_341204_;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder withEntry(LootPoolEntryContainer.Builder<?> p_80931_) {
            this.entries.add((Object)p_80931_.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetContainerContents(this.getConditions(), this.component, (List<LootPoolEntryContainer>)this.entries.build());
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

